/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.CustomCardMaker.components;

import LegendaryCardMaker.CustomCardMaker.CustomCardMakerFrame;
import LegendaryCardMaker.CustomCardMaker.components.JIconMenuItem;
import LegendaryCardMaker.CustomCardMaker.components.TextMenuItem;
import LegendaryCardMaker.CustomCardMaker.structure.CustomElement;
import LegendaryCardMaker.CustomCardMaker.structure.ElementIcon;
import LegendaryCardMaker.CustomCardMaker.structure.ElementText;
import LegendaryCardMaker.Icon;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;

public class CustomIconMenu
extends JMenu
implements ActionListener {
    public CustomCardMakerFrame frame = null;
    public ElementIcon icon = null;
    private List<JIconMenuItem> iconsMenuItems = new ArrayList<JIconMenuItem>();

    public CustomIconMenu(CustomCardMakerFrame frame, ElementIcon icon) {
        super(icon.name);
        this.frame = frame;
        this.icon = icon;
        if (icon.childElements != null && icon.childElements.size() > 0) {
            for (CustomElement e : icon.childElements) {
                if (!(e instanceof ElementText)) continue;
                this.add(new TextMenuItem(frame, (ElementText)e));
            }
        }
        if (icon.allowChange) {
            JMenu icons = new JMenu("Icon");
            JMenu teams = new JMenu("Teams");
            JMenu attributes = new JMenu("Attributes");
            JMenu powers = new JMenu("Powers");
            for (Icon i : Icon.values()) {
                JIconMenuItem mi = new JIconMenuItem(i);
                if (i.equals(icon.getIconValue())) {
                    mi.setSelected(true);
                }
                mi.setActionCommand("icon_" + i.getEnumName());
                mi.addActionListener(this);
                if (i.getIconType().equals((Object)Icon.ICON_TYPE.TEAM)) {
                    teams.add(mi);
                }
                if (i.getIconType().equals((Object)Icon.ICON_TYPE.POWER)) {
                    powers.add(mi);
                }
                if (i.getIconType().equals((Object)Icon.ICON_TYPE.ATTRIBUTE)) {
                    attributes.add(mi);
                }
                this.iconsMenuItems.add(mi);
            }
            if (icon.iconType == null) {
                icons.add(attributes);
                icons.add(powers);
                icons.add(teams);
                this.add(icons);
            } else if (icon.iconType.equals((Object)Icon.ICON_TYPE.TEAM)) {
                this.add(teams);
            } else if (icon.iconType.equals((Object)Icon.ICON_TYPE.ATTRIBUTE)) {
                this.add(attributes);
            } else if (icon.iconType.equals((Object)Icon.ICON_TYPE.POWER)) {
                this.add(powers);
            }
        }
        if (icon.optional) {
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem("Visible");
            mi.setSelected(true);
            mi.setActionCommand("visible");
            mi.addActionListener(this);
            this.add(mi);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("visible")) {
            this.icon.visible = ((JCheckBoxMenuItem)e.getSource()).isSelected();
            for (CustomElement el : this.icon.childElements) {
                el.visible = this.icon.visible;
            }
            this.frame.setCursor(Cursor.getPredefinedCursor(3));
            this.frame.reRenderCard();
            this.frame.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (e.getActionCommand().startsWith("icon_")) {
            for (JIconMenuItem i : this.iconsMenuItems) {
                if (e.getActionCommand().equals("icon_" + i.icon.getEnumName())) {
                    i.setSelected(true);
                    this.icon.value = i.icon;
                    continue;
                }
                i.setSelected(false);
            }
            this.frame.setCursor(Cursor.getPredefinedCursor(3));
            this.frame.reRenderCard();
            this.frame.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

